/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8275.BoxInfo;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class UnicastAddrModify
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275.GeneralResources");
    DestinationPropBook myBook;
    JdmBrowser browser;
    NavigationContext myContext;
    BoxInfo boxInfo;
    MessageBox messageToUser;
    boolean emptyRow;
    boolean loggingOn = false;
    Serializable macAddress;
    Serializable vlanId;
    Integer portNum;
    Integer securityMode;
    String errorMsg;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser.getIsApplication()) {
            this.loggingOn = Log.getLog().getLoggingState();
        }
        ModelInfo modelInfo = jDMWizardInfo.getCurrentRow();
        Hashtable hashtable = jDMWizardInfo.getItems();
        if (modelInfo == null) {
            if (this.loggingOn) {
                System.out.println("BB: empty Row");
            }
            this.errorMsg = new String("WZ_emptyRow");
            this.emptyRow = true;
            this.browser.displayMsg(UnicastAddrModify.getNLSString(this.errorMsg));
            this.messageToUser = new MessageBox(this.browser.getFrame(), UnicastAddrModify.getNLSString("UM_error"), UnicastAddrModify.getNLSString(this.errorMsg), true);
            hashtable.put("modifySecurityMode", new Integer(1));
            hashtable.remove("modifyMacAddr");
            hashtable.remove("modifyVlanIdNum");
            hashtable.remove("modifyPort");
            return;
        }
        this.emptyRow = false;
        this.vlanId = modelInfo.get("Index.VlanIdNum");
        this.macAddress = modelInfo.get("Index.MacAddr");
        this.portNum = (Integer)modelInfo.get("Panel.UnicastAddrPortNum");
        this.securityMode = (Integer)modelInfo.get("Panel.PhonyAdminStatus");
        hashtable.put("modifyMacAddr", this.macAddress);
        hashtable.put("modifyVlanIdNum", this.vlanId);
        hashtable.put("modifyPort", this.portNum);
        hashtable.put("modifySecurityMode", this.securityMode);
        this.browser.displayMsg(UnicastAddrModify.getNLSString("WZ_modify"));
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl;
        block20: {
            Integer n;
            Integer n2;
            ModelInfo modelInfo;
            GenModel genModel;
            block19: {
                genModel = null;
                modelInfo = null;
                n2 = null;
                n = null;
                bl = true;
                this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
                if (this.browser == null && this.myBook != null) {
                    this.browser = (JdmBrowser)this.myBook.getBrowser();
                }
                if (this.browser == null) {
                    System.out.println("BB:UnicastAddrModify can't get browser- can't proceed with modify");
                    bl = false;
                }
                if (this.emptyRow) {
                    bl = false;
                }
                if (this.boxInfo == null) {
                    this.boxInfo = BoxInfo.getFromNavContext(this.myBook.getNavContext(), true);
                }
                if (bl) {
                    if (this.browser.getIsApplication()) {
                        this.loggingOn = Log.getLog().getLoggingState();
                    }
                    if (this.loggingOn) {
                        System.out.println("BB:UnicastAddrModify Proceed entry.");
                    }
                    Hashtable hashtable = jDMWizardInfo.getItems();
                    genModel = jDMWizardInfo.getModel();
                    try {
                        n2 = (Integer)hashtable.get("modifyPort");
                        n = (Integer)hashtable.get("modifySecurityMode");
                    }
                    catch (Exception exception) {
                        if (this.loggingOn) {
                            System.out.println("BB: unexpected/missing user data- can't create row");
                        }
                        this.errorMsg = new String("WZ_missingInfo");
                        bl = false;
                    }
                }
                if (bl && this.securityMode == 2) {
                    modelInfo = new ModelInfo();
                    modelInfo.add("Index.MacAddr", this.macAddress);
                    modelInfo.add("Index.VlanIdNum", this.vlanId);
                    modelInfo.add("Panel.PhonyAdminStatus", new Integer(1));
                    try {
                        modelInfo = genModel.setInfo("Panel", modelInfo);
                        bl = this.checkSnmpResponse(modelInfo);
                        if (!bl) {
                            this.errorMsg = new String("WZ_badSet");
                        }
                    }
                    catch (Exception exception) {
                        bl = false;
                        this.errorMsg = new String("WZ_badSet");
                        if (!this.loggingOn) break block19;
                        System.out.println("BB: Exception setting unicast modify data");
                        exception.printStackTrace();
                    }
                }
            }
            if (bl) {
                modelInfo = new ModelInfo();
                modelInfo.add("Index.MacAddr", this.macAddress);
                modelInfo.add("Index.VlanIdNum", this.vlanId);
                modelInfo.add("Panel.UnicastAddrPortNum", n2);
                modelInfo.add("Panel.PhonyAdminStatus", n);
                try {
                    modelInfo = genModel.setInfo("Panel", modelInfo);
                    bl = this.checkSnmpResponse(modelInfo);
                    if (!bl) {
                        this.errorMsg = new String("WZ_badSet");
                    }
                }
                catch (Exception exception) {
                    bl = false;
                    this.errorMsg = new String("WZ_badSet");
                    if (!this.loggingOn) break block20;
                    System.out.println("BB: Exception setting modifying unicast  data");
                    exception.printStackTrace();
                }
            }
        }
        if (!bl && this.browser != null) {
            this.browser.displayMsg(UnicastAddrModify.getNLSString(this.errorMsg));
            this.messageToUser = new MessageBox(this.browser.getFrame(), UnicastAddrModify.getNLSString("UM_error"), UnicastAddrModify.getNLSString(this.errorMsg), true);
        }
        return bl;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string);
            if (!(serializable instanceof SpecialValue)) continue;
            System.out.println("BB: Error in snmp set. Variable is " + string + "  SpecialValue is " + serializable);
            bl = false;
            break;
        }
        return bl;
    }
}

